/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommandsTask;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.websm.launch.hscmgt.SystemConfigurationOverview;
import com.ibm.hwmca.base.settings.network.NetAppFirewallRule;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.settings.network.config.NetworkApplicationConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.base.settings.network.config.PortConfig;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HMCModify
extends HMCCommandsTask {
    private static final String NETWORK_PARAM = "network";
    private static final String NETW_TIME_PROTOCOL_PARAM = "xntp";
    private static final String SSH_PARAM = "ssh";
    private static final String HTTP_PARAM = "http";
    private static final String WEBSM_PARAM = "websm";
    private static final String SYSLOG_PARAM = "syslog";
    private static final String KBDCFG_PARAM = "kbdcfg";
    private static final String ENABLE_PARAM = "enable";
    private static final String DISABLE_PARAM = "disable";
    private static final String ADD_PARAM = "add";
    private static final String REMOVE_PARAM = "remove";
    private static final String MODIFY_PARAM = "modify";
    private static final String DHCP_PARAM = "dhcp";
    private Boolean sshSetting;
    private Boolean websmSetting;
    private Boolean httpSetting;
    private Boolean syslogSetting;
    private Boolean kbdcfgSetting;
    private Boolean xntpSetting;
    private boolean modifyXNTP;
    private boolean lparCommSetting;
    private boolean addConfig;
    private boolean removeConfig;
    private boolean fwConfig;
    private boolean lparCommConfig;
    private String nameserver;
    private String domainsuffix;
    private String ifname;
    private String ipaddrStr;
    private String netmaskStr;
    private String ntpversion;
    private InetAddress ipaddr;
    private InetAddress netmask;
    private String hostname;
    private String domainname;
    private String gateway;
    private String fwPorts;
    private String fwProtocol;
    private String fwAppName;
    private String realUser;
    private static final int NUM_VALID_PARMS = 10;
    private HashMap m_validParms = new HashMap(21, 0.5f);

    public HMCModify() {
        this.m_validParms.put(HMCCommandUtils.CONFIG_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.STATE_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.HOSTNAME_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.DOMAINNAME_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.GATEWAY_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.INTERFACE_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.IPADDR_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.NETMASK_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.NAMESERVER_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.DOMAINSUFFIX_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.NTPVERSION_PARAM, null);
        this.m_validParms.put("--lparcomm", null);
    }

    public void checkValidCombination(HashMap hashMap) throws PIHscClientException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.m_validParms.containsKey(string)) continue;
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_COMBINATION", stringArray, null);
        }
    }

    private String[] listRemove(String[] stringArray, String string) throws PIHscClientException {
        String[] stringArray2;
        if (stringArray != null && stringArray.length != 0) {
            stringArray2 = new String[stringArray.length - 1];
            boolean bl = false;
            int n = stringArray.length - 2;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!bl && string.equals(stringArray[i])) {
                    bl = true;
                    continue;
                }
                if (n < 0) continue;
                stringArray2[n--] = stringArray[i];
            }
            if (bl) {
                return stringArray2;
            }
        }
        stringArray2 = new String[]{string};
        throw new PIHscClientException("8000", "HSCCommonBundle", "NOT_FOUND_IN_LIST", stringArray2, null);
    }

    private String[] listAdd(String[] stringArray, String string) {
        int n = stringArray == null ? 1 : stringArray.length + 1;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n - 1; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n - 1] = string;
        return stringArray2;
    }

    private boolean fwRule(NetworkInterfaceInformation networkInterfaceInformation) {
        boolean bl = false;
        NetAppFirewallRule netAppFirewallRule = new NetAppFirewallRule(this.fwAppName, networkInterfaceInformation.getIfname(), this.ipaddrStr, this.netmaskStr, this.fwProtocol, this.fwPorts);
        ArrayList<NetAppFirewallRule> arrayList = networkInterfaceInformation.getFirewallRules();
        if (arrayList != null) {
            bl = arrayList.contains(netAppFirewallRule);
        }
        if (this.addConfig) {
            if (bl) {
                return false;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<NetAppFirewallRule>();
            }
            arrayList.add(netAppFirewallRule);
        } else {
            if (!bl) {
                return false;
            }
            arrayList.remove(netAppFirewallRule);
        }
        networkInterfaceInformation.setFirewallRules(arrayList);
        return true;
    }

    private int invokeCommand() throws Exception {
        int n = 0;
        if (this.sshSetting != null || this.httpSetting != null || this.websmSetting != null || this.syslogSetting != null || this.xntpSetting != null || this.kbdcfgSetting != null) {
            PIHscUtil.initHscUtil(3);
            this.performCommand();
            if (this.modifyXNTP && this.ipaddrStr != null) {
                this.xntpSetting = null;
                n = this.invokeViaTasklet();
            }
        } else {
            n = this.invokeViaTasklet();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performCommand() throws Exception, HSCException {
        int n;
        String[] stringArray;
        List list;
        NetworkInfo networkInfo;
        String[] stringArray2;
        String[] stringArray3;
        block81: {
            int n2;
            boolean bl;
            int n3;
            String[] stringArray4;
            block78: {
                NetworkApplicationConfig[] networkApplicationConfigArray;
                block79: {
                    NetworkInterfaceInformation networkInterfaceInformation;
                    block82: {
                        block80: {
                            block77: {
                                String string = "";
                                stringArray3 = new String[3];
                                stringArray2 = new String[]{""};
                                if (this.sshSetting != null) {
                                    SystemConfigurationOverview.doRemoteAccess(this.sshSetting, null);
                                    stringArray3[0] = SystemConfigurationOverview.sshEnabled() != false ? ENABLE_PARAM : DISABLE_PARAM;
                                    String string2 = "HSCE2109 User name " + this.realUser + ": Modified remote execution settings to: ssh " + stringArray3[0];
                                    HSCLogUtils.logSystemEvent((short)2109, string2, stringArray3, this.realUser);
                                    return;
                                }
                                if (this.httpSetting != null) {
                                    Object object;
                                    int n4;
                                    block72: {
                                        n4 = 0;
                                        try {
                                            if (this.httpSetting.booleanValue()) {
                                                stringArray3[0] = ENABLE_PARAM;
                                                object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings http enable");
                                            } else {
                                                stringArray3[0] = DISABLE_PARAM;
                                                object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings http disable");
                                            }
                                            n4 = ((Process)object).waitFor();
                                        }
                                        catch (Throwable throwable) {
                                            if (!IDebug.enabled()) break block72;
                                            throwable.printStackTrace();
                                        }
                                    }
                                    if (n4 != 0) throw new PIHscClientException("8016", "HSCCommonBundle", "COMMAND_LINE_ERROR_HTTP_SETTINGS", null, null);
                                    object = "HSCE2178 User name " + this.realUser + ": Modified web server settings to: " + stringArray3[0];
                                    HSCLogUtils.logSystemEvent((short)2178, (String)object, stringArray3, this.realUser);
                                    return;
                                }
                                if (this.websmSetting != null) {
                                    Object object;
                                    int n5;
                                    block73: {
                                        n5 = 0;
                                        try {
                                            if (this.websmSetting.booleanValue()) {
                                                stringArray3[0] = ENABLE_PARAM;
                                                object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings websm enable");
                                            } else {
                                                stringArray3[0] = DISABLE_PARAM;
                                                object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings websm disable");
                                            }
                                            n5 = ((Process)object).waitFor();
                                        }
                                        catch (Throwable throwable) {
                                            if (!IDebug.enabled()) break block73;
                                            throwable.printStackTrace();
                                        }
                                    }
                                    if (n5 != 0) throw new PIHscClientException("8016", "HSCCommonBundle", "COMMAND_LINE_ERROR_WEBSM_SETTINGS", null, null);
                                    object = "HSCE2177 User name " + this.realUser + ": Modified websm server settings to: " + stringArray3[0];
                                    HSCLogUtils.logSystemEvent((short)2177, (String)object, stringArray3, this.realUser);
                                    return;
                                }
                                if (this.syslogSetting != null) {
                                    Object object;
                                    int n6;
                                    block74: {
                                        n6 = 0;
                                        String string3 = "";
                                        if (this.ipaddrStr != null) {
                                            string3 = this.ipaddrStr;
                                        }
                                        if (this.hostname != null) {
                                            string3 = this.hostname;
                                        }
                                        try {
                                            object = this.addConfig ? Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings syslog add " + string3) : Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings syslog remove " + string3);
                                            n6 = ((Process)object).waitFor();
                                        }
                                        catch (Throwable throwable) {
                                            if (!IDebug.enabled()) break block74;
                                            throwable.printStackTrace();
                                        }
                                    }
                                    if (n6 != 0) throw new PIHscClientException("8016", "HSCCommonBundle", "COMMAND_LINE_ERROR_SYSLOGD_SETTINGS", null, null);
                                    object = "HSCE2179 User name " + this.realUser + ": Modified syslog server settings";
                                    HSCLogUtils.logSystemEvent((short)2179, (String)object, null, this.realUser);
                                    return;
                                }
                                if (this.xntpSetting != null) {
                                    Object object;
                                    String string4;
                                    int n7;
                                    block76: {
                                        n7 = 0;
                                        string4 = "";
                                        try {
                                            if (!this.addConfig && !this.removeConfig) {
                                                if (this.xntpSetting.booleanValue()) {
                                                    stringArray3[0] = ENABLE_PARAM;
                                                    object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp enable");
                                                } else {
                                                    stringArray3[0] = DISABLE_PARAM;
                                                    object = Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp disable");
                                                }
                                            } else {
                                                String string5 = "";
                                                n7 = 0;
                                                if (this.ntpversion != null) {
                                                    string5 = this.ntpversion;
                                                }
                                                if (this.ipaddrStr != null) {
                                                    string4 = this.ipaddrStr;
                                                } else if (this.hostname != null) {
                                                    string4 = this.hostname;
                                                }
                                                object = this.addConfig ? Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp add " + string4 + " " + string5) : Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings xntp remove " + string4 + " " + string5);
                                            }
                                            n7 = ((Process)object).waitFor();
                                        }
                                        catch (Throwable throwable) {
                                            if (!IDebug.enabled()) break block76;
                                            throwable.printStackTrace();
                                        }
                                    }
                                    if (n7 != 0) {
                                        if (!this.removeConfig) throw new PIHscClientException("8016", "HSCCommonBundle", "COMMAND_LINE_ERROR_XNTP_SETTINGS", null, null);
                                        throw new PIHscClientException("8016", "HSCCommonBundle", "COMMAND_LINE_ERROR_XNTP_SERVER_NOTFOUND", null, null);
                                    }
                                    object = "";
                                    if (this.addConfig) {
                                        object = "HSCE2192 User name " + this.realUser + ": Modified xntp server settings to add " + string4;
                                        HSCLogUtils.logSystemEvent((short)2192, (String)object, null, this.realUser);
                                        return;
                                    }
                                    if (this.removeConfig) {
                                        object = "HSCE2193 User name " + this.realUser + ": Modified xntp server settings to remove " + string4;
                                        HSCLogUtils.logSystemEvent((short)2193, (String)object, null, this.realUser);
                                        return;
                                    }
                                    object = "HSCE2191 User name " + this.realUser + ": Modified xntp server settings to " + stringArray3[0];
                                    HSCLogUtils.logSystemEvent((short)2191, (String)object, stringArray3, this.realUser);
                                    return;
                                }
                                if (this.kbdcfgSetting != null) {
                                    int n8 = 0;
                                    try {
                                        Process process = this.kbdcfgSetting != false ? Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings kbdcfg enable") : Runtime.getRuntime().exec("/opt/hsc/bin/SystemSettings kbdcfg disable");
                                        n8 = process.waitFor();
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        if (!IDebug.enabled()) return;
                                        throwable.printStackTrace();
                                        return;
                                    }
                                }
                                networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                                list = NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo();
                                stringArray = new String[list.size()];
                                n = 0;
                                stringArray4 = new String[list.size()];
                                n3 = -1;
                                for (int i = 0; i < list.size(); ++i) {
                                    networkInterfaceInformation = (NetworkInterfaceInformation)list.get(i);
                                    stringArray4[i] = networkInterfaceInformation.getIfname();
                                    if (this.ifname == null || !this.ifname.equals(networkInterfaceInformation.getIfname())) continue;
                                    n3 = i;
                                }
                                if (this.ifname != null && n3 == -1) {
                                    String[] stringArray5 = new String[]{HMCCommandUtils.INTERFACE_PARAM};
                                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray5, null);
                                }
                                if (!this.fwConfig) break block77;
                                networkApplicationConfigArray = NetworkSettingsConfig.getNetworkSettingsConfig().getNetAppsArray();
                                bl = false;
                                if (networkApplicationConfigArray == null) break block78;
                                break block79;
                            }
                            if (!this.addConfig) break block80;
                            if (this.nameserver != null) {
                                networkInfo.setDNSServers(this.listAdd(networkInfo.getDNSServers(), this.nameserver));
                            }
                            if (this.domainsuffix != null) {
                                networkInfo.setDomainSuffixes(this.listAdd(networkInfo.getDomainSuffixes(), this.domainsuffix));
                            }
                            break block81;
                        }
                        if (!this.removeConfig) break block82;
                        if (this.nameserver != null) {
                            networkInfo.setDNSServers(this.listRemove(networkInfo.getDNSServers(), this.nameserver));
                        }
                        if (this.domainsuffix != null) {
                            networkInfo.setDomainSuffixes(this.listRemove(networkInfo.getDomainSuffixes(), this.domainsuffix));
                        }
                        break block81;
                    }
                    if (this.hostname != null) {
                        networkInfo.setComputerName(this.hostname);
                    }
                    if (this.domainname != null) {
                        networkInfo.setDomainName(this.domainname);
                    }
                    if (this.gateway != null) {
                        networkInfo.setDefaultGateway(this.gateway);
                    }
                    if (this.ifname != null) {
                        networkInterfaceInformation = (NetworkInterfaceInformation)list.get(n3);
                        if (this.ipaddrStr != null && this.ipaddrStr.equals(DHCP_PARAM)) {
                            networkInterfaceInformation.setDhcpClient(true);
                            this.netmaskStr = "";
                        } else {
                            if (networkInterfaceInformation.isDhcpClient()) {
                                if (this.ipaddr == null) {
                                    String[] stringArray6 = new String[]{HMCCommandUtils.IPADDR_PARAM};
                                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray6, null);
                                }
                                if (this.netmask == null) {
                                    String[] stringArray7 = new String[]{HMCCommandUtils.NETMASK_PARAM};
                                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray7, null);
                                }
                                networkInterfaceInformation.setDhcpClient(false);
                            }
                            if (this.ipaddr != null) {
                                networkInterfaceInformation.setIpAddress(this.ipaddr);
                            }
                            if (this.netmask != null) {
                                networkInterfaceInformation.setNetworkMask(this.netmask);
                            }
                            this.ipaddrStr = networkInterfaceInformation.getIpAddr();
                            this.netmaskStr = networkInterfaceInformation.getNetMask();
                        }
                        if (this.lparCommConfig) {
                            networkInterfaceInformation.setPartitionCommunication(this.lparCommSetting);
                        }
                    }
                    break block81;
                }
                for (n2 = 0; n2 < networkApplicationConfigArray.length; ++n2) {
                    if (!this.fwAppName.equalsIgnoreCase(networkApplicationConfigArray[n2].getApplicationID()) && !this.fwAppName.equalsIgnoreCase(networkApplicationConfigArray[n2].getName())) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    PortConfig[] portConfigArray = networkApplicationConfigArray[n2].getPortsArray();
                    for (int i = 0; i < portConfigArray.length; ++i) {
                        stringBuffer.append(portConfigArray[i].getNumber());
                        if (i + 1 == portConfigArray.length) continue;
                        stringBuffer.append(",");
                    }
                    this.fwPorts = stringBuffer.toString();
                    this.fwAppName = networkApplicationConfigArray[n2].getApplicationID();
                    this.fwProtocol = portConfigArray[0].getType() == 1 ? "tcp" : "udp";
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                String[] stringArray8 = new String[]{HMCCommandUtils.CONFIG_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray8, null);
            }
            if (this.ifname == null) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!this.fwRule((NetworkInterfaceInformation)list.get(n2))) continue;
                    stringArray[n++] = stringArray4[n2];
                }
            } else if (this.fwRule((NetworkInterfaceInformation)list.get(n3))) {
                stringArray[n++] = stringArray4[n3];
            }
            if (n == 0) {
                if (!this.addConfig) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FIREWALL_REMOVE_FAILED", null, null);
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FIREWALL_ADD_FAILED", null, null);
            }
        }
        NetworkSettings.getNetworkSettings().setNetworkInterfaceInfo(list);
        NetworkSettings.getNetworkSettings().applyNetworkSettings(networkInfo);
        if (this.fwConfig) {
            stringArray3[0] = this.fwAppName + " " + this.fwPorts + "/" + this.fwProtocol + " " + this.ipaddrStr + "/" + this.netmaskStr;
            stringArray3[1] = HMCCommandUtils.flattenArray(stringArray, n);
            if (this.addConfig) {
                String string = "HSCE2188 User name " + this.realUser + ": Added firewall rule " + stringArray3[0] + " for interfaces " + stringArray3[1];
                HSCLogUtils.logSystemEvent((short)2188, string, stringArray3, this.realUser);
                return;
            }
            String string = "HSCE2189 User name " + this.realUser + ": Removed firewall rule " + stringArray3[0] + " for interfaces " + stringArray3[1];
            HSCLogUtils.logSystemEvent((short)2189, string, stringArray3, this.realUser);
            return;
        }
        if (this.addConfig || this.removeConfig) {
            String[] stringArray9 = null;
            if (this.nameserver != null) {
                stringArray9 = networkInfo.getDNSServers();
                if (stringArray9 == null || stringArray9.length == 0) {
                    stringArray9 = stringArray2;
                }
                stringArray3[0] = HMCCommandUtils.flattenArray(stringArray9, stringArray9.length);
                String string = "HSCE2110 User name " + this.realUser + ": Modified DNS Server search order to: " + stringArray3[0];
                HSCLogUtils.logSystemEvent((short)2110, string, stringArray3, this.realUser);
            }
            if (this.domainsuffix == null) return;
            stringArray9 = networkInfo.getDomainSuffixes();
            if (stringArray9 == null || stringArray9.length == 0) {
                stringArray9 = stringArray2;
            }
            stringArray3[0] = HMCCommandUtils.flattenArray(stringArray9, stringArray9.length);
            String string = "HSCE2111 User name " + this.realUser + ": Modified Domain Suffix search order to: " + stringArray3[0];
            HSCLogUtils.logSystemEvent((short)2111, string, stringArray3, this.realUser);
            return;
        }
        if (this.ifname != null) {
            stringArray3[0] = this.ifname;
            stringArray3[1] = this.ipaddrStr;
            if (stringArray3[1] == null) {
                stringArray3[1] = "";
            }
            stringArray3[2] = this.netmaskStr;
            if (stringArray3[2] == null) {
                stringArray3[2] = "";
            }
            String string = "HSCE2112 User name " + this.realUser + ": Modified network settings of interface " + stringArray3[0] + " to: IP address " + stringArray3[1] + ", Network Mask " + stringArray3[2];
            HSCLogUtils.logSystemEvent((short)2112, string, stringArray3, this.realUser);
        }
        if (this.hostname == null && this.domainname == null) {
            if (this.gateway == null) return;
        }
        stringArray3[0] = networkInfo.getComputerName();
        if (stringArray3[0] == null) {
            stringArray3[0] = "";
        }
        stringArray3[1] = networkInfo.getDomainName();
        if (stringArray3[1] == null) {
            stringArray3[1] = "";
        }
        stringArray3[2] = networkInfo.getDefaultGateway();
        if (stringArray3[2] == null) {
            stringArray3[2] = "";
        }
        String string = "HSCE2113 User name " + this.realUser + ": Modified network settings to: Host Name " + stringArray3[0] + ", Domain Name " + stringArray3[1] + ", Default Gateway " + stringArray3[2];
        HSCLogUtils.logSystemEvent((short)2113, string, stringArray3, this.realUser);
    }

    public InetAddress validateIPAddr(String string, String string2) throws PIHscClientException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            String[] stringArray = new String[]{string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
        }
        return inetAddress;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mapParameters(HashMap hashMap) throws RequiredParameterException, PIHscClientException {
        String string;
        block43: {
            Object[] objectArray;
            String string2;
            String string3;
            String string4;
            block46: {
                block47: {
                    block41: {
                        block45: {
                            block44: {
                                block42: {
                                    string = null;
                                    string4 = null;
                                    string3 = null;
                                    string2 = null;
                                    this.sshSetting = null;
                                    this.xntpSetting = null;
                                    this.websmSetting = null;
                                    this.httpSetting = null;
                                    this.syslogSetting = null;
                                    this.kbdcfgSetting = null;
                                    this.ipaddr = null;
                                    this.netmask = null;
                                    this.ipaddrStr = null;
                                    this.netmaskStr = null;
                                    this.fwPorts = null;
                                    this.fwProtocol = null;
                                    this.addConfig = false;
                                    this.removeConfig = false;
                                    this.fwConfig = false;
                                    this.lparCommConfig = false;
                                    this.realUser = System.getProperty("HMCRealUser.name");
                                    string4 = (String)hashMap.get(HMCCommandUtils.CONFIG_PARAM);
                                    string3 = (String)hashMap.get(HMCCommandUtils.STATE_PARAM);
                                    this.ipaddrStr = (String)hashMap.get(HMCCommandUtils.IPADDR_PARAM);
                                    this.netmaskStr = (String)hashMap.get(HMCCommandUtils.NETMASK_PARAM);
                                    this.ifname = (String)hashMap.get(HMCCommandUtils.INTERFACE_PARAM);
                                    this.nameserver = (String)hashMap.get(HMCCommandUtils.NAMESERVER_PARAM);
                                    this.domainsuffix = (String)hashMap.get(HMCCommandUtils.DOMAINSUFFIX_PARAM);
                                    this.hostname = (String)hashMap.get(HMCCommandUtils.HOSTNAME_PARAM);
                                    this.domainname = (String)hashMap.get(HMCCommandUtils.DOMAINNAME_PARAM);
                                    this.gateway = (String)hashMap.get(HMCCommandUtils.GATEWAY_PARAM);
                                    this.ntpversion = (String)hashMap.get(HMCCommandUtils.NTPVERSION_PARAM);
                                    string2 = (String)hashMap.get("--lparcomm");
                                    if (string4 != null) {
                                        string4 = string4.trim().toLowerCase();
                                    }
                                    if (string3 != null) {
                                        string3 = string3.trim().toLowerCase();
                                    }
                                    if (string4 == null || string3 == null) {
                                        Object[] objectArray2 = new String[]{HMCCommandUtils.CONFIG_PARAM + ", " + HMCCommandUtils.STATE_PARAM};
                                        string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", null, objectArray2);
                                        throw new RequiredParameterException(string);
                                    }
                                    this.m_validParms.clear();
                                    this.m_validParms.put(HMCCommandUtils.CONFIG_PARAM, null);
                                    this.m_validParms.put(HMCCommandUtils.STATE_PARAM, null);
                                    if (!string3.equals(ENABLE_PARAM) && !string3.equals(DISABLE_PARAM)) break block41;
                                    if (!(string4.equals(SSH_PARAM) || string4.equals(HTTP_PARAM) || string4.equals(KBDCFG_PARAM) || string4.equals(NETW_TIME_PROTOCOL_PARAM) || string4.equals(WEBSM_PARAM))) {
                                        String[] stringArray = new String[]{HMCCommandUtils.CONFIG_PARAM};
                                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
                                    }
                                    if (!string4.equals(SSH_PARAM)) break block42;
                                    this.sshSetting = new Boolean(string3.equals(ENABLE_PARAM));
                                    break block43;
                                }
                                if (!string4.equals(HTTP_PARAM)) break block44;
                                this.httpSetting = new Boolean(string3.equals(ENABLE_PARAM));
                                break block43;
                            }
                            if (!string4.equals(WEBSM_PARAM)) break block45;
                            this.websmSetting = new Boolean(string3.equals(ENABLE_PARAM));
                            break block43;
                        }
                        if (string4.equals(KBDCFG_PARAM)) {
                            this.kbdcfgSetting = new Boolean(string3.equals(ENABLE_PARAM));
                            break block43;
                        } else if (string4.equals(NETW_TIME_PROTOCOL_PARAM)) {
                            this.xntpSetting = new Boolean(string3.equals(ENABLE_PARAM));
                        }
                        break block43;
                    }
                    if (!string3.equals(ADD_PARAM) && !string3.equals(REMOVE_PARAM)) break block46;
                    if (string3.equals(ADD_PARAM)) {
                        this.addConfig = true;
                    } else {
                        this.removeConfig = true;
                    }
                    if (!string4.equals(SYSLOG_PARAM)) break block47;
                    this.m_validParms.put(HMCCommandUtils.HOSTNAME_PARAM, null);
                    this.m_validParms.put(HMCCommandUtils.IPADDR_PARAM, null);
                    this.syslogSetting = new Boolean(true);
                    if (this.ipaddrStr != null) {
                        this.ipaddrStr = this.ipaddrStr.trim();
                        this.ipaddr = this.validateIPAddr(this.ipaddrStr, HMCCommandUtils.IPADDR_PARAM);
                    }
                    if (this.ipaddrStr != null && this.hostname != null) {
                        string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYSLOG_PARAMETER", "Cannot specify both IP address and hostName");
                        throw new RequiredParameterException(string);
                    }
                    break block43;
                }
                if (string4.equals(NETWORK_PARAM)) {
                    Object[] objectArray3;
                    this.m_validParms.put(HMCCommandUtils.NAMESERVER_PARAM, null);
                    this.m_validParms.put(HMCCommandUtils.DOMAINSUFFIX_PARAM, null);
                    if (this.nameserver != null) {
                        this.nameserver = this.nameserver.trim();
                        objectArray3 = this.validateIPAddr(this.nameserver, HMCCommandUtils.NAMESERVER_PARAM);
                    }
                    if (this.domainsuffix != null) {
                        this.domainsuffix = this.domainsuffix.trim();
                    }
                    if (this.nameserver == null && this.domainsuffix == null) {
                        objectArray3 = new String[]{HMCCommandUtils.NAMESERVER_PARAM + ", " + HMCCommandUtils.DOMAINSUFFIX_PARAM};
                        string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SPECIFY_ONE_OR_MORE", null, objectArray3);
                        throw new RequiredParameterException(string);
                    }
                    break block43;
                } else {
                    this.m_validParms.put(HMCCommandUtils.IPADDR_PARAM, null);
                    this.m_validParms.put(HMCCommandUtils.NETMASK_PARAM, null);
                    this.m_validParms.put(HMCCommandUtils.INTERFACE_PARAM, null);
                    if (string4.equals(NETW_TIME_PROTOCOL_PARAM)) {
                        this.m_validParms.put(HMCCommandUtils.NTPVERSION_PARAM, null);
                        this.m_validParms.put(HMCCommandUtils.HOSTNAME_PARAM, null);
                        this.modifyXNTP = true;
                        this.xntpSetting = new Boolean(true);
                        if (this.ipaddrStr != null && this.hostname != null) {
                            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYSLOG_PARAMETER", "Cannot specify both IP address and hostName");
                            throw new RequiredParameterException(string);
                        }
                    }
                    this.fwConfig = true;
                    this.fwAppName = string4.equals(SSH_PARAM) ? "ssh.name" : (string4.equals(WEBSM_PARAM) ? "WebSM.name" : (string4.equals(HTTP_PARAM) ? "Web.name" : (string4.equals(NETW_TIME_PROTOCOL_PARAM) ? "ntp.name" : string4)));
                    if (this.ipaddrStr == null) {
                        if (!this.modifyXNTP) {
                            String[] stringArray = new String[]{HMCCommandUtils.IPADDR_PARAM};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                        }
                    } else {
                        this.ipaddrStr = this.ipaddrStr.trim();
                        this.ipaddr = this.validateIPAddr(this.ipaddrStr, HMCCommandUtils.IPADDR_PARAM);
                    }
                    this.netmaskStr = this.netmaskStr != null ? this.netmaskStr.trim() : "255.255.255.255";
                    this.netmask = this.validateIPAddr(this.netmaskStr, HMCCommandUtils.NETMASK_PARAM);
                    if (this.ifname != null) {
                        this.ifname = this.ifname.trim();
                    }
                }
                break block43;
            }
            if (!string3.equals(MODIFY_PARAM)) {
                String[] stringArray = new String[]{HMCCommandUtils.STATE_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.m_validParms.put(HMCCommandUtils.HOSTNAME_PARAM, null);
            this.m_validParms.put(HMCCommandUtils.DOMAINNAME_PARAM, null);
            this.m_validParms.put(HMCCommandUtils.GATEWAY_PARAM, null);
            if (!string4.equals(NETWORK_PARAM)) {
                String[] stringArray = new String[]{HMCCommandUtils.CONFIG_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            if (this.ifname != null) {
                this.m_validParms.put(HMCCommandUtils.INTERFACE_PARAM, null);
                this.m_validParms.put(HMCCommandUtils.IPADDR_PARAM, null);
                this.m_validParms.put("--lparcomm", null);
                this.ifname = this.ifname.trim();
                if (this.ipaddrStr != null) {
                    this.ipaddrStr = this.ipaddrStr.trim();
                    if (this.ipaddrStr.equalsIgnoreCase(DHCP_PARAM)) {
                        this.ipaddrStr = DHCP_PARAM;
                    } else {
                        this.ipaddr = this.validateIPAddr(this.ipaddrStr, HMCCommandUtils.IPADDR_PARAM);
                        this.m_validParms.put(HMCCommandUtils.NETMASK_PARAM, null);
                    }
                } else {
                    this.m_validParms.put(HMCCommandUtils.NETMASK_PARAM, null);
                }
                if (this.netmaskStr != null) {
                    this.netmaskStr = this.netmaskStr.trim();
                    this.netmask = this.validateIPAddr(this.netmaskStr, HMCCommandUtils.NETMASK_PARAM);
                }
                if (string2 != null) {
                    if ((string2 = string2.trim()).equalsIgnoreCase("on")) {
                        this.lparCommSetting = true;
                    } else {
                        if (!string2.equalsIgnoreCase("off")) {
                            String[] stringArray = new String[]{"--lparcomm"};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
                        }
                        this.lparCommSetting = false;
                    }
                    this.lparCommConfig = true;
                }
                if (this.ipaddrStr == null && this.netmaskStr == null && string2 == null) {
                    Object[] objectArray4 = new String[]{HMCCommandUtils.IPADDR_PARAM + ", " + HMCCommandUtils.NETMASK_PARAM + ", " + "--lparcomm"};
                    string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SPECIFY_ONE_OR_MORE", null, objectArray4);
                    throw new RequiredParameterException(string);
                }
            }
            if (this.hostname != null) {
                this.hostname = this.hostname.trim();
            }
            if (this.domainname != null) {
                this.domainname = this.domainname.trim();
            }
            if (this.gateway != null) {
                this.gateway = this.gateway.trim();
                objectArray = this.validateIPAddr(this.gateway, HMCCommandUtils.GATEWAY_PARAM);
            }
            if (this.ifname == null && this.hostname == null && this.domainname == null && this.gateway == null) {
                objectArray = new String[]{HMCCommandUtils.INTERFACE_PARAM + ", " + HMCCommandUtils.HOSTNAME_PARAM + ", " + HMCCommandUtils.DOMAINNAME_PARAM + ", " + HMCCommandUtils.GATEWAY_PARAM};
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SPECIFY_ONE_OR_MORE", null, objectArray);
                throw new RequiredParameterException(string);
            }
        }
        if (this.ntpversion != null && this.xntpSetting == null) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_XNTP_PARAMETER_INVALID", "Cannot specify --ntpversion");
            throw new RequiredParameterException(string);
        }
        this.checkValidCombination(hashMap);
    }

    public void printResults() {
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHHMC_HELP"));
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = null;
        int n2 = 0;
        PIHscUtil.initHscUtil(3);
        HMCModify hMCModify = new HMCModify();
        try {
            object = null;
            if (0 == stringArray.length) {
                hMCModify.printHelp();
                bl = true;
            }
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n];
                arrayList.add(object);
                if (!((String)object).equals("--help")) continue;
                hMCModify.printHelp();
                bl = true;
                break;
            }
            if (!bl) {
                HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, hMCModify.m_validParms);
                hMCModify.mapParameters(hashMap);
                n2 = hMCModify.invokeCommand();
            }
        }
        catch (PIHscClientException pIHscClientException) {
            if ("8000".equals(pIHscClientException.getHscExId())) {
                System.out.println(pIHscClientException.getMessage());
            } else {
                pIHscClientException.printStackTrace(System.out);
                String string2 = pIHscClientException.getMessage();
                if (string2 == null) {
                    string2 = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
                }
                System.out.println(string2);
            }
            n2 = 1;
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            n2 = 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            n2 = 1;
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            n2 = 1;
        }
        try {
            object = new String[]{"chhmc"};
            for (n = 0; n < stringArray.length; ++n) {
                Object object2 = object;
                object2[0] = (String)object2[0] + " " + stringArray[n];
            }
            if (n2 == 0) {
                HSCLogUtils.logSystemEvent((short)2123, "", (String[])object, PIHscUtil.getOriginalUser());
            } else {
                HSCLogUtils.logSystemEvent((short)2124, "", (String[])object, PIHscUtil.getOriginalUser());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(n2);
    }
}

